<?php

namespace Albedo\Gamification\Providers\Fakers;

use Faker\Provider\Base;

class ImageFakerProvider extends Base
{

    public static function image(int $width = 640, int $height = 480): string
    {
        $path = storage_path() . DIRECTORY_SEPARATOR . 'app' . DIRECTORY_SEPARATOR . Uuid::uuid1() . '.png';
        $im = imagecreate($width, $height);

        imagecolorallocate($im, rand(0, 255), rand(0, 255), rand(0, 255));
        imagepng($im, $path);

        return $path;
    }

}
