<?php

use Albedo\Gamification\GamificationServiceProvider;
use Albedo\Gamification\Models\Agreement;
use Albedo\Gamification\Models\UserAgreement;
use Albedo\Gamification\Services\GamificationAgreementHandler;
use Illuminate\Http\Request;
use function Pest\Laravel\getJson;

it('should return agreements list', function () {

    Agreement::create([
        'name' => 'Test',
        'label' => 'Test',
        'required' => 1,
        'text' => 'test',
    ]);

    getJson(route('gamification.agreements'))
        ->assertStatus(200);
});


it('register with agreements - saves UserAgreements', function () {

    $user = \Albedo\Auth\Tests\Models\User::factory()->create();

    Agreement::insert([
        ['name' => 'regulations', 'required' => 1],
        ['name' => 'privacy_policy', 'required' => 0]
    ]);

    $data = [
        'first_name' => 'Jan',
        'last_name' => 'Kowalski',
        'email' => 'j.kowalski@albedomarketing.pl',
        'email_confirmation' => 'j.kowalski@albedomarketing.pl',
        'password' => 'password123!',
        'password_confirmation' => 'password123!',
        'phone_number' => '123456789',
        'avatar_id' => 1,
        'agreement_regulations' => true,
        'agreement_privacy_policy' => false,
    ];

    GamificationAgreementHandler::handleAgreements($user, new Request($data));

    expect(UserAgreement::where('user_id', $user->id)->where('name', 'regulations')->first()->accepted)->toBeTrue();
    expect(UserAgreement::where('user_id', $user->id)->where('name', 'privacy_policy')->first()->accepted)->toBeFalse();
});
