<?php

namespace Albedo\Gamification\Services;

use Albedo\Auth\Contracts\MustAcceptUserAgreements;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Http\Request;
use Albedo\Gamification\Models\Agreement;
use Albedo\Gamification\Models\UserAgreement;

class GamificationAgreementHandler implements MustAcceptUserAgreements
{
    public function handleAgreements(Authenticatable $user, Request $request): void
    {
        $agreementNames = Agreement::pluck('name')->toArray();
        $submitted = $request->only($agreementNames);

        foreach ($agreementNames as $name) {
            $accepted = array_key_exists($name, $submitted) ? (bool)$submitted[$name] : false;
            UserAgreement::create([
                'user_id' => $user->id,
                'name' => $name,
                'accepted' => $accepted
            ]);
        }
    }
}
