<?php

namespace Albedo\Gamification\Models\Traits;

use Albedo\Gamification\Enums\ActivityGroupEnum;
use Albedo\Gamification\Models\Point;
use Illuminate\Database\Eloquent\Relations\MorphMany;
use Illuminate\Support\Facades\DB;

trait HasPointsTrait
{
    public function points(): MorphMany
    {
        return $this->morphMany(Point::class, Point::MORPH_NAME_RECEIVER);
    }

    public function calculatePoints()
    {
        return $this->points->sum('points');
    }

    public function calculatePointsDetail()
    {
        $points = Point::query()
            ->whereMorphedTo(Point::MORPH_NAME_RECEIVER, $this)
            ->select(DB::raw('MAX(activity_group) as name, SUM(points) as points'))
            ->whereIn('activity_group', ActivityGroupEnum::available())
            ->groupBy('activity_group')
            ->pluck('points', 'name');

        $allPoints = collect(ActivityGroupEnum::available())
            ->pluck('value')
            ->mapWithKeys(fn($name) => [$name => [
                'name' => ActivityGroupEnum::from($name)->label(),
                'points' => 0,
                'hex' => ActivityGroupEnum::from($name)->hex()
            ]]);

        return $allPoints->merge($points->map(fn($points, $name) => [
            'name' => ActivityGroupEnum::from($name)->label(),
            'points' => $points,
            'hex' => ActivityGroupEnum::from($name)->hex()
        ]))->values();
    }
}
