<?php

namespace Albedo\Gamification\Http\Controllers;

use Albedo\Gamification\Http\Resources\RuleContentResource;
use Albedo\Gamification\RuleContent;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Response;
use Livewire\Attributes\Rule;

class RuleContentAction extends Controller
{
    public function __invoke()
    {
        $user = Auth::user();
        $user->load('roles');

        $ruleContent = RuleContent::query()
            ->with(['media'])
            ->where(fn($q) => $q
                ->whereHas('roles', fn($q) => $q->whereIn('name', $user->roles->pluck('name')->toArray()))
                ->orWhereDoesntHave('roles'))
            ->latest()
            ->first();

        return Response::success(data: !$ruleContent ? (object)[] : RuleContentResource::make($ruleContent));
    }
}
