<?php

namespace Albedo\Gamification\Filament\RuleContents\Schemas;

use Filament\Forms\Components\RichEditor;
use Filament\Forms\Components\Select;
use Filament\Schemas\Schema;

class RuleContentForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                RichEditor::make('content')
                    ->label('Treść')
                    ->extraAttributes(['style' => 'min-height: 400px;']),
                Select::make('roles')
                    ->multiple()
                    ->relationship(name: 'roles', titleAttribute: 'name')
                    ->preload(),

            ])
            ->columns(1);
    }
}
