<?php

namespace Albedo\Gamification\Filament\RuleContents;

use Albedo\Gamification\RuleContent;
use Albedo\Gamification\Filament\RuleContents\Pages\CreateRuleContent;
use Albedo\Gamification\Filament\RuleContents\Pages\EditRuleContent;
use Albedo\Gamification\Filament\RuleContents\Pages\ListRuleContents;
use Albedo\Gamification\Filament\RuleContents\Pages\ViewRuleContent;
use Albedo\Gamification\Filament\RuleContents\Schemas\RuleContentForm;
use Albedo\Gamification\Filament\RuleContents\Schemas\RuleContentInfolist;
use Albedo\Gamification\Filament\RuleContents\Tables\RuleContentsTable;
use BackedEnum;
use Filament\Resources\Resource;
use Filament\Schemas\Schema;
use Filament\Support\Icons\Heroicon;
use Filament\Tables\Table;

class RuleContentResource extends Resource
{
    protected static ?string $model = RuleContent::class;

    protected static string|BackedEnum|null $navigationIcon = Heroicon::OutlinedRectangleStack;

    public static function form(Schema $schema): Schema
    {
        return RuleContentForm::configure($schema);
    }

    public static function infolist(Schema $schema): Schema
    {
        return RuleContentInfolist::configure($schema);
    }

    public static function table(Table $table): Table
    {
        return RuleContentsTable::configure($table);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => ListRuleContents::route('/'),
            'create' => CreateRuleContent::route('/create'),
            'view' => ViewRuleContent::route('/{record}'),
            'edit' => EditRuleContent::route('/{record}/edit'),
        ];
    }
}
