<?php

namespace Albedo\Gamification\Http\Controllers;

use Albedo\Gamification\Http\Resources\AvatarResource;
use Albedo\Gamification\Models\Avatar;
use Illuminate\Support\Facades\Response;
use Illuminate\Routing\Controller;

/**
 * Pobierz dostępne awatary użytkownika.
 *
 * Endpoint zwraca wszystkie awatary dostępne do wyboru.
 *
 * @response 200 {"data": [...]}
 */
class AvatarAction extends Controller
{
    /**
     * Zwraca wszystkie awatary dostępne w systemie.
     *
     * @response 200 {"data": [...]}
     */
    public function __invoke()
    {
        $avatars = Avatar::all();

       return Response::success(data: AvatarResource::collection($avatars));
    }
}
