<?php

use Albedo\Gamification\Models\Avatar;
use Albedo\Gamification\Tests\Models\User;
use function Pest\Laravel\actingAs;
use function Pest\Laravel\patchJson;

it('updates user avatar', function () {
    $user = User::factory()->create();
    $avatar = Avatar::create(['name' => 'Testowy avatar']);

    actingAs($user);
    $response = patchJson(route('gamification.update-avatar'), [
        'avatar_id' => $avatar->id,
    ]);

    $response->assertStatus(200)
        ->assertJson(['status' => 'success']);

    expect($user->avatars()->first()->id)->toBe($avatar->id);
});

it('returns an error if avatar_id does not exist', function () {
    $user = User::factory()->create();
    actingAs($user);
    $response = patchJson(route('gamification.update-avatar'), [
        'avatar_id' => 99999,
    ]);

    $response->assertStatus(422);
    $response->assertJsonValidationErrors('avatar_id');
});
