<?php

namespace Albedo\Gamification\Services;

use Albedo\Gamification\Contracts\MustAcceptUserAgreements;
use Albedo\Gamification\Models\Agreement;
use Albedo\Gamification\Rules\DynamicAgreementRule;
use Illuminate\Http\Request;

class AgreementService
{
    public static function prepareAgreementsList(): array
    {
        $agreements = Agreement::all();

        return $agreements->map(function (Agreement $agreement, $key) {
            return [
                'key' => $agreement->agreement_key,
                'must_be_accepted' => $agreement->required,
                'text' => $agreement->parsed_text,
                'label' => $agreement->label,
            ];
        })
            ->toArray();
    }

    public function acceptAgreementsFromRequest(MustAcceptUserAgreements $user, Request $request): void
    {
        Agreement::all()->each(function (Agreement $agreement) use ($user, $request) {

            $agreementKey = $agreement->getAgreementKey();

            if ($request->has($agreementKey)) {
                $user->userAgreements()
                    ->updateOrCreate([
                        'name' => $agreement->name,
                    ], [
                        'accepted' => (bool)$request->get($agreementKey),
                    ]);
            }
        });
    }

    public function getAgreementRules(): array
    {
        $agreements = Agreement::all();

        return Agreement::all()
            ->mapWithKeys(fn(Agreement $agreement) => [
                $agreement->getAgreementKey() => new DynamicAgreementRule($agreements)
            ])
            ->toArray();
    }
}
