<?php

namespace Albedo\Gamification\Dtos;

use Albedo\Gamification\PointCategory;
use App\Contracts\PointActivityContract;
use App\Contracts\PointReceivableContract;
use App\Models\User;
use Illuminate\Database\Eloquent\Model;

class PointDto
{
    public function __construct(
        protected User                               $user,
        protected PointCategory                      $pointCategory,
        protected Model&PointReceivableContract      $receiver,
        protected int                                $points,
        protected (Model&PointActivityContract)|null $activity = null,
        protected ?string                            $comment = null
    )
    {
    }

    public function getPointCategory(): PointCategory
    {
        return $this->pointCategory;
    }

    public function getReceiver(): Model&PointReceivableContract
    {
        return $this->receiver;
    }

    public function getPoints(): int
    {
        return $this->points;
    }

    public function getActivity(): (Model&PointActivityContract)|null
    {
        return $this->activity;
    }

    public function getComment(): ?string
    {
        return $this->comment;
    }

    public function getUser(): User
    {
        return $this->user;
    }
}
