<?php

namespace Albedo\Gamification\Models\Traits;

use Albedo\Gamification\Models\Avatar;
use Albedo\Gamification\Models\UserAvatar;
use App\Models\UserHasAvatar;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\Relations\HasOneThrough;

trait HasUserAvatar
{
    public function avatar(): HasOneThrough
    {
        return $this->hasOneThrough(Avatar::class, UserAvatar::class);
    }

    public function avatars(): BelongsToMany
    {
        return $this->belongsToMany(Avatar::class, UserAvatar::class);
    }

    public function getAvatarUrl(): string
    {
        return  $this->avatar->getFirstMediaUrl('avatar');
    }

    public function getAvatarId()
    {
        return $this->avatar?->id;
    }
}
