<?php

namespace Albedo\Gamification\Http\Controllers;

use Albedo\Gamification\Services\AgreementService;
use Illuminate\Support\Facades\Response;

/**
 * Pobierz listę zgód w module gamifikacji.
 *
 * Endpoint zwraca listę zgód wymaganych w module gamifikacji.
 *
 * @response 200 {"data": [...]}
 */
class AgreementAction
{

    public function __construct(protected AgreementService $agreementService)
    {

    }

    /**
     * Zwraca listę przygotowanych zgód do zaakceptowania przez użytkownika.
     *
     * @response 200 {"data": [{
     *      "key": "rule",
     *      "must_be_accepted": 1,
     *      "text": "Akceptuję regulamin",
     *      "label": "Regulamin"
     * },{
     *      "key": "marketing",
     *      "must_be_accepted": 0,
     *      "text": "Wyrażam zgodę na otrzymywanie informacji marketingowych",
     *      "label": "Marketing"
     * }]]}
     */
    public function __invoke()
    {
        return Response::success(data: [
            $this->agreementService->prepareAgreementsList(),
        ]);
    }
}
