<?php

namespace Albedo\Gamification\Enums;

use Albedo\Gamification\Enums\Trait\CaseRandom;

enum ActivityGroupEnum: string
{
    use CaseRandom;

    case CUSTOM = 'custom';
    case ELEARNING = 'e-learning';

    case DUEL = 'duel';

    case CHALLENGE = 'challenge';

    case BUSINESS_TASK = 'business_task';

    case STICKER = 'sticker';

    case QUESTIONNAIRE = 'questionnaire';

    public function label(): string
    {
        return match ($this) {
            self::DUEL => 'Duels',
            self::ELEARNING => 'Educational tasks',
            self::CHALLENGE => 'Challenges',
            self::BUSINESS_TASK => 'Business tasks',
            self::CUSTOM => 'Others',
            self::STICKER => 'Stickers',
            self::QUESTIONNAIRE => 'Questionnaires',
        };
    }

    public function hex(): string
    {
        return match ($this) {
            self::DUEL => '#2BD4D9',
            self::ELEARNING => '#ED285B',
            self::CHALLENGE => '#F39323',
            self::BUSINESS_TASK => '#2D32AA',
            self::CUSTOM => '#000',
            self::STICKER => '#FFFFFF',
        };
    }

    public static function available(): array
    {
        return [
            self::DUEL,
            self::ELEARNING,
            self::CHALLENGE,
            self::BUSINESS_TASK,
            self::CUSTOM,
        ];
    }

    public static function options(): array
    {
        return [
            self::DUEL->value => 'duel',
            self::ELEARNING->value => 'rules',
            self::CHALLENGE->value => 'challenge',
            self::BUSINESS_TASK->value => 'business_task',
            self::CUSTOM->value => 'others',
            self::STICKER->value => 'sticker',
        ];
    }
}
