<?php

namespace Albedo\Gamification\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Illuminate\Database\Eloquent\SoftDeletes;

class Point extends Model
{
    use HasFactory, SoftDeletes;

    public const MORPH_NAME_ACTIVITY = 'activity';
    public const MORPH_NAME_RECEIVER = 'receiver';

    protected $guarded = [];

    public function user(): BelongsTo
    {
        return $this->belongsTo(config('users.model'));
    }

    public function pointCategory(): BelongsTo
    {
        return $this->belongsTo(PointCategory::class);
    }

    public function receiver(): MorphTo
    {
        return $this->morphTo();
    }

    public function activity(): MorphTo
    {
        return $this->morphTo();
    }
}
