<?php

namespace Albedo\Gamification\Services;

use Albedo\Gamification\Contracts\HasAvatar;

class AvatarService
{
    public function assignAvatarFromRequest(HasAvatar $user, array $data): void
    {
        $avatarId = $data['avatar_id'];

        $user->avatars()->attach($avatarId);
    }

    public function getAvatarRules(): array
    {
        return [
            'avatar_id' => ['required', 'exists:avatars,id'],
        ];
    }
}
