<?php

namespace Albedo\Gamification\Filament\Attachments\Schemas;

use Albedo\Gamification\Models\FileType;
use Filament\Forms\Components\Select;
use Filament\Forms\Components\SpatieMediaLibraryFileUpload;
use Filament\Forms\Components\TextInput;
use Filament\Schemas\Schema;
use function Pest\Laravel\options;

class AttachmentForm
{
    public static function configure(Schema $schema): Schema
    {
        return $schema
            ->components([
                Select::make('file_type_id')
                    ->required()
                    ->options(FileType::all()->pluck('name', 'id'))
                    ->unique(ignoreRecord: true)
                    ->reactive()
                    ->label('Typ pliku'),
                SpatieMediaLibraryFileUpload::make("pdf")
                    ->validationMessages([
                        'required' => 'Plik pdf jest wymagany, gdy zewnętrzny link do pliku jest pusty',
                    ])->collection('rule')
                    ->label('Plik pdf')
                    ->preserveFilenames()
                    ->disk('public')
                    ->required(fn($get) => !$get('url'))
                    ->lazy(),
                TextInput::make('url')
                    ->label('Zewnętrzny link do pliku'),
            ]);
    }
}
