<?php

namespace Albedo\Gamification\Services;

use Albedo\Auth\Services\User;
use Albedo\Gamification\Models\Agreement;
use Albedo\Gamification\Models\Document;

class AgreementService
{
    public static function prepareAgreementsList(): array
    {
        $documents = Document::all();
        $agreements = Agreement::all();

        $agreementResponse = [];

        foreach ($agreements as $agreement) {
            foreach ($documents as $document) {
                $agreement->text = str_replace(
                    'begin_of_inserted_document_' . $document->name . '_end_of_inserted_document',
                    route('document.name', $document->name . config('system.document_mime_type')),
                    $agreement->text
                );
            }

            $agreementResponse[$agreement->name] = [
                'must_be_accepted' => $agreement->required,
                'text' => $agreement->text,
                'label' => $agreement->label,
            ];
        }
        return $agreementResponse;
    }

    public function saveAgreementsForUser(User $user, array $agreements): void
    {
        $user->update([
            'agreements' => $agreements
        ]);
    }
}
