<?php

namespace Albedo\Duel\Services;

use Albedo\Duel\Enums\DuelProgressStatusEnum;
use Albedo\Duel\Http\Resources\DuelResource;
use Albedo\Duel\Models\Duel;
use Albedo\Duel\Models\DuelRound;
use Albedo\Duel\Exceptions\NoActiveDuelRoundException;
use Albedo\Duel\Exceptions\NoActiveDuelException;

class CurrentDuelService
{
    public function handle(int $userId): DuelResource
    {
        $duelRound = DuelRound::getCurrent();

        if (!$duelRound) {
            throw new NoActiveDuelRoundException();
        }

        $duel = Duel::whereHas('duelUsers', fn($q) => $q
            ->where('user_id', $userId)
            ->where('duel_round_id', $duelRound->id)
            ->whereIn('progress_status', [
                DuelProgressStatusEnum::IN_PROGRESS,
                DuelProgressStatusEnum::NOT_PARTICIPATED
            ]))
            ->with([
                'duelUsers.duelUserAnswers',
                'duelUsers.duelUserAnswers.duelQuestion.duelQuestionCategory'
            ])
            ->first();

        if (!$duel) {
            throw new NoActiveDuelException();
        }

        $me = $duel->duelUsers->where('user_id', $userId)->first();
        $opponent = $duel->duelUsers->where('user_id', '!=', $userId)->first();
        return DuelResource::make($duel)->additional([
            'me' => $me,
            'opponent' => $opponent
        ]);
    }
}
