<?php

namespace Albedo\Duel\Models\Traits;

use Illuminate\Database\Eloquent\Builder;

trait InteractsWithDuelUserAnswer
{
    public function isTimeout(): bool
    {
        return (bool)$this->timeout;
    }

    public function hasAnswered(): bool
    {
        return $this->getAttribute('duel_answer_id') !== null
            || $this->getAttribute('answer_expiration_date')?->isPast();
    }

    public function isCorrect()
    {
        if ($this->isTimeout()){
            return 'timeout';
        }
        return $this->getAttribute('is_correct');
    }

    public function state(): string
    {
        if ($this->isTimeout()) {
            return 'timeout';
        }
        if ($this->getAttribute('duel_answer_id') !== null) {
            return $this->getAttribute('is_correct') ? 'correct' : 'incorrect';
        }
        return 'pending';
    }

    public function isExposed(): bool
    {
        return $this->duelUser->isFinished()
            || (auth()->id() === $this->duelUser->user_id && $this->duelUser->isFinished());
    }


    public function scopeAnswered(Builder $query): Builder
    {
        return $query->whereNotNull('duel_answer_id')
            ->orWhereNotNull('answer_expiration_date');
    }

    public function scopePending(Builder $query): Builder
    {
        return $query->whereNull('duel_answer_id')
            ->whereNull('answer_expiration_date');
    }

    public function scopeTimedOut(Builder $query): Builder
    {
        return $query->where('timeout', true);
    }

    public function scopeForDuel(Builder $query, int $duelId): Builder
    {
        return $query->where('duel_id', $duelId);
    }

    public function scopeForUser(Builder $query, int $userId): Builder
    {
        return $query->whereHas('duelUser', fn($q) => $q->where('user_id', $userId));
    }
}
