<?php

namespace Albedo\Duel\Models\Traits;

use Albedo\Duel\Enums\DuelProgressStatusEnum;
use Albedo\Duel\Enums\DuelResultStatusEnum;
use Illuminate\Database\Eloquent\Builder;

trait HasDuelResultStatus
{
    public function isWinner(): bool
    {
        return $this->attribute('result_status')  === DuelResultStatusEnum::WINNER;
    }

    public function isLoser(): bool
    {
        return $this->attribute('result_status')  === DuelResultStatusEnum::LOSER;
    }

    public function isUnknown(): bool
    {
        return $this->attribute('result_status')  === DuelResultStatusEnum::UNKNOWN;
    }

    public function isDraw(): bool
    {
        return $this->attribute('result_status') === DuelResultStatusEnum::DRAW;
    }

    public function scopeWinner(Builder $query): Builder
    {
        return $query->where('progress_status', DuelResultStatusEnum::WINNER);
    }

    public function scopeLoser(Builder $query): Builder
    {
        return $query->where('progress_status', DuelResultStatusEnum::LOSER);
    }

    public function scopeUnknown(Builder $query): Builder
    {
        return $query->where('progress_status', DuelResultStatusEnum::UNKNOWN);
    }

    public function scopeDraw(Builder $query): Builder
    {
        return $query->where('progress_status', DuelResultStatusEnum::DRAW);
    }

}
