<?php

namespace Albedo\Duel\Models;

use Albedo\Duel\Enums\DuelProgressStatusEnum;
use Albedo\Duel\Models\Traits\HasDuelProgressStatus;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Illuminate\Database\Eloquent\SoftDeletes;

class Duel extends Model
{
    use HasDuelProgressStatus,
        HasFactory,
        SoftDeletes;

    protected $fillable = [
        'duel_round_id',
        'progress_status',
    ];

    protected $casts = [
        'progress_status' => DuelProgressStatusEnum::class,
    ];

    public function duelRound(): BelongsTo
    {
        return $this->belongsTo(DuelRound::class);
    }

    public function duelUsers(): HasMany
    {
        return $this->hasMany(DuelUser::class);
    }

    public function duelUserAnswers(): HasMany
    {
        return $this->hasMany(DuelUserAnswer::class);
    }

    public function users(): BelongsToMany
    {
        return $this->belongsToMany(config('duel.user_model'), DuelUser::class);
    }

    public function scopeForRound(Builder $query, int $roundId): Builder
    {
        return $query->where('duel_round_id', $roundId);
    }

    public function scopeForUser(Builder $query, int $userId): Builder
    {
        return $query->whereHas('duelUsers', fn($q) => $q->where('user_id', $userId));
    }

    /**
     * Factory
     */
    protected static function newFactory()
    {
        return \Albedo\Duel\Database\Factories\DuelFactory::new();
    }
}
