<?php

namespace Albedo\Duel\Models\Traits;

use Albedo\Duel\Models\Duel;
use Albedo\Duel\Models\DuelUser;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;

trait HasDuels
{
    public function duelUsers(): HasMany
    {
        return $this->hasMany(DuelUser::class);
    }

    public function duels(): BelongsToMany
    {
        return $this->belongsToMany(Duel::class, DuelUser::class);
    }

}
