<?php

namespace Albedo\Duel\Models\Traits;

use Albedo\Duel\Enums\DuelProgressStatusEnum;
use Illuminate\Database\Eloquent\Builder;

trait HasDuelProgressStatus
{
    public function isFinished(): bool
    {
        return $this->getAttribute('progress_status') === DuelProgressStatusEnum::FINISHED;
    }

    public function isInProgress(): bool
    {
        return $this->getAttribute('progress_status') === DuelProgressStatusEnum::IN_PROGRESS;
    }

    public function isNotParticipated(): bool
    {
        return $this->getAttribute('progress_status') === DuelProgressStatusEnum::NOT_PARTICIPATED;
    }

    /**
     * TODO
     */
    public function hasParticipated()
    {
        return in_array($this->progress_status, [
            DuelProgressStatusEnum::IN_PROGRESS,
            DuelProgressStatusEnum::FINISHED
        ]);
    }

    /**
     * TODO
     */
    public function notParticipated()
    {
        return $this->progress_status === DuelProgressStatusEnum::NOT_PARTICIPATED;
    }

    public function scopeFinished(Builder $query): Builder
    {
        return $query->where('progress_status', DuelProgressStatusEnum::FINISHED);
    }

    public function scopeInProgress(Builder $query): Builder
    {
        return $query->where('progress_status', DuelProgressStatusEnum::IN_PROGRESS);
    }

    public function scopeNotParticipated(Builder $query): Builder
    {
        return $query->where('progress_status', DuelProgressStatusEnum::NOT_PARTICIPATED);
    }

}
