<?php

namespace Albedo\Duel\Models\Traits;

use Albedo\Duel\Models\DuelUserAnswer;
use Albedo\Duel\Services\DuelService;
use Albedo\Duel\Settings\DuelSettings;

Trait DuelAnswerTime
{
    public function time(): Attribute
    {
        if ($this->duelUserAnswers
            ->reject(fn(DuelUserAnswer $duelUserAnswer) => is_null($duelUserAnswer->answer_expiration_date))->isEmpty()) {
            return Attribute::make();
        }

        return Attribute::make(
            get: fn() => $this->duelUserAnswers
                ->sum(fn(duelUserAnswer $duelUserAnswer) => $duelUserAnswer->answer_time ?? 46 * 1000));
    }

    public function formattedTime(): string
    {
        $seconds = $this->time / 1000;
        $minutes = intdiv($seconds, 60);
        $remainingSeconds = $seconds % 60;

        return sprintf('%02d:%02d', $minutes, $remainingSeconds);
    }

    public function getSumTimeFormatted(): string
    {
        return $this->getSumTimeSeconds();
    }

    public function getSumTimeSeconds(): int
    {
        return $this->duelUserAnswers
            ->each(fn(duelUserAnswer $duelUserAnswer) => $this->updateAnswerTimeIsNull($duelUserAnswer))
            ->sum(fn(duelUserAnswer $duelUserAnswer) => $this->getAnswerTime($duelUserAnswer));
    }

    public function getMaxTime(): int
    {
        return DuelService::getMaxTotalAnswerTimeInMs(app(DuelSettings::class));
    }

    public function getAnswerTime(duelUserAnswer $duelUserAnswer): int
    {
        return $duelUserAnswer->answer_time ?? $this->maxTotalAnswerTime;
    }

    public function updateAnswerTimeIsNull(DuelUserAnswer $duelUserAnswer): void
    {
            $duelUserAnswer->answer_time ?? $duelUserAnswer->update(['answer_time' => $this->getMaxTime()]);
    }

}
