<?php

namespace Albedo\Duel\Commands;

use albedo\Duel\Facades\Duel;
use Albedo\Duel\Models\DuelRound;
use Albedo\Duel\Services\DuelRoundService;
use Carbon\Carbon;
use Carbon\CarbonPeriod;
use Illuminate\Console\Command;

class DuelRoundGeneratorCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'duel:create-rounds';


    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    public function __construct(
        private DuelRoundService $duelRoundService
    ) {
        parent::__construct();
    }

    /**
     * Execute the console command.
     */
    public function handle(): int
    {
        try {
            $this->info('Starting duel rounds creation...');

            $this->duelRoundService->createDuelRounds();

            $this->info('Duel rounds created successfully!');

            return Command::SUCCESS;

        } catch (\Exception $e) {
            $this->error('Failed to create duel rounds: ' . $e->getMessage());

            return Command::FAILURE;
        }
    }
}
