<?php

namespace App\ScheduleFunctions;

use App\Models\DuelRound;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Schedule;

function ScheduleDuel(): void
{
    Schedule::command('userDuel:make')
        ->dailyAt('07:00')
        ->when(function () {
            if (!app()->isProduction()) {
                return false;
            }
            return DuelRound::whereDate('begin_date', now())->exists();
        })
        ->onSuccess(fn() => Log::info('Duel created.'));

    Schedule::command('userDuel:close')
        ->dailyAt('15:00')
        ->when(function () {
            if (!app()->isProduction()) {
                return false;
            }
            return DuelRound::whereDate('end_date', now())->exists();
        })
        ->onSuccess(fn() => Log::info('Duel closed.'));

    Schedule::command('make:send-email-remind-duels')
        ->dailyAt('07:00')
        ->when(function () {
            if (!app()->isProduction()) {
                return false;
            }
            return DuelRound::whereDate('end_date', now())->exists();
        })
        ->onSuccess(fn() => Log::info('Duel emails remind sent.'));
}
