<?php

use Albedo\Duel\Models\Duel;
use Albedo\Duel\Models\DuelAnswer;
use Albedo\Duel\Models\DuelQuestion;
use Albedo\Duel\Models\DuelUser;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        Schema::create('duel_user_answers', function (Blueprint $table) {
            $table->id();
            $table->foreignIdFor(Duel::class);
            $table->foreignIdFor(DuelUser::class);
            $table->foreignIdFor(DuelQuestion::class);
            $table->foreignIdFor(DuelAnswer::class)->nullable();
            $table->boolean('is_correct')->default(0);
            $table->dateTime('answer_expiration_date')->nullable();
            $table->integer('answer_time')->nullable();
            $table->boolean('timeout')->default(0);
            $table->tinyInteger('number');
            $table->tinyInteger('number_by_category')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        Schema::dropIfExists('duel_user_answers');
    }
};
