<?php

namespace Albedo\Duel\Listeners;

use Albedo\Duel\Enums\DuelProgressStatusEnum;
use Albedo\Duel\Events\DuelCloseEvent;
use Albedo\Duel\Events\DuelPossibleEndEvent;
use Albedo\Duel\Models\Duel;
use Albedo\Duel\Models\DuelUser;
use Albedo\Duel\Models\DuelUserAnswer;

class CheckIfDuelShouldBeClosedListener
{
    public function handle(DuelPossibleEndEvent $event): void
    {
        $event->duel
            ->duelUsers
            ->each(function (DuelUser $duelUser) {

                $duelUserAnswerCount = $duelUser->duelUserAnswers
                    ->reject(fn(DuelUserAnswer $duelUserAnswer) => !is_null($duelUserAnswer->answer_expiration_date))
                    ->count();

                if ($duelUserAnswerCount === 0 && $duelUser->progress_status !== DuelProgressStatusEnum::FINISHED) {

                    $duelUser->update([
                        'progress_status' => DuelProgressStatusEnum::FINISHED,
                        'time' =>  $duelUser->getSumTimeSeconds(),
                    ]);

                }
            });

        $numberOfNoResponses = $event->duel
            ->duelUserAnswers
            ->reject(fn(DuelUserAnswer $duelUserAnswer) => !is_null($duelUserAnswer->answer_expiration_date))
            ->count();

        if ($numberOfNoResponses === 0 and $event->duel->progress_status !== DuelProgressStatusEnum::FINISHED) {
            event(new DuelCloseEvent($event->duel));
        }
    }
}
