<?php

namespace Albedo\Duel\Http\Resources;

use Albedo\Duel\Contracts\DuelUserDataProvider;
use Albedo\Duel\Models\DuelUserAnswer;
use Albedo\Duel\Settings\DuelSettings;
use Illuminate\Http\Resources\Json\JsonResource;

class DuelUserResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return array_merge(

            $this->when($this->user,
                fn() => app(DuelUserDataProvider::class)->getData($this->user),
                []
            ),

            [
                'progress_status' => $this->progress_status,
                'result_status' => $this->result_status,
                'time' => $this->formattedTime(),
                'points' => $this->points ?? 0,
                'answers' => $this->whenLoaded(
                    'duelUserAnswers', fn() => $this->duelUserAnswers
                    ->filter(fn(DuelUserAnswer $duelUserAnswer) => $duelUserAnswer->isExposed())
                    ->map(fn(DuelUserAnswer $duelUserAnswer) => DuelUserAnswerResource::make($duelUserAnswer))
                ),
                'answered' => $this->whenLoaded(
                    'duelUserAnswers', fn() => $this->duelUserAnswers
                    ->groupBy(fn(DuelUserAnswer $answer) => $answer->duelQuestion?->duelQuestionCategory?->name)
                    ->map(fn($answers) => $answers->map(fn($a) => $a->isCorrect())->values())
                )
            ]);
    }
}
