<?php

namespace Albedo\Duel\Http\Controllers;

use Albedo\Duel\Services\DuelHistoryService;
use Exception;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Response;

class DuelHistoryAction extends Controller
{
    public function __construct(
        protected DuelHistoryService $getDuelHistory
    ) {}

    public function __invoke()
    {
        $userId = (int) auth()->id();
        try {
            $duelHistory = $this->getDuelHistory->handle($userId);
        } catch (Exception $e) {
            return Response::generalError();
        }

        return Response::success(data: $duelHistory, message: "Success");
    }
}
