<?php

namespace Albedo\Duel\Http\Resources;

use Albedo\Duel\Models\Duel;
use Albedo\Duel\Models\DuelUserAnswer;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Auth;

class DuelResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'id' => $this->id,
            'name' => $this->duelRound?->name,
            'begin_date' => $this->duelRound?->begin_date?->format('d.m'),
            'end_date' => $this->duelRound?->end_date?->format('d.m.Y'),
            'status' => $this->progress_status,

            'me' => $this->when($this->additional['me'] ?? null,
                fn() => new DuelUserResource($this->additional['me'])
            ),

            'opponent' => $this->when($this->additional['opponent'] ?? null,
                fn() => new DuelUserResource($this->additional['opponent'])
            ),
        ];
    }
}
