<?php

namespace Albedo\Duel\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;

class DuelAnswer extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function duelQuestion(): BelongsTo
    {
        return $this->belongsTo(DuelQuestion::class);
    }

    public function duelUserAnswer(): HasMany
    {
        return $this->hasMany(DuelUserAnswer::class);
    }
}
