<?php

namespace Albedo\Duel\Models;

use Albedo\Duel\Enums\DuelProgressStatusEnum;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Duel extends Model
{
    use HasFactory;

    const STATUS_DONE = 'done';

    protected $guarded = [];

    public function duelRound(): BelongsTo
    {
        return $this->belongsTo(DuelRound::class);
    }

    public function duelUsers(): HasMany
    {
        return $this->hasMany(DuelUser::class);
    }

    public function duelUserAnswers(): HasMany
    {
        return $this->hasMany(DuelUserAnswer::class);
    }

    public function users(): BelongsToMany
    {
        return $this->belongsToMany(config('duel.user_model'), DuelUser::class);
    }

    public function isFinished(): bool
    {
        return $this->progress_status === DuelProgressStatusEnum::FINISHED->value;
    }
}
