<?php

namespace albedo\Duel;

use Albedo\Duel\Events\DuelCloseEvent;
use Albedo\Duel\Events\DuelPossibleEndEvent;
use Albedo\Duel\Listeners\CheckIfDuelShouldBeClosedListener;
use Albedo\Duel\Listeners\CloseDuelListener;
use Albedo\Duel\Models\Duel;
use Albedo\Duel\Policies\DuelPolicy;
use Illuminate\Support\Facades\Event;
use Illuminate\Support\Facades\Gate;
use Spatie\LaravelPackageTools\Package;
use Spatie\LaravelPackageTools\PackageServiceProvider;

class DuelServiceProvider extends PackageServiceProvider
{

    public function configurePackage(Package $package): void
    {
        /*
         * This class is a Package Service Provider
         *
         * More info: https://github.com/spatie/laravel-package-tools
         */
        $package
            ->name('duel')
            ->hasConfigFile()
            ->hasRoute('duel')
            ->hasMigrations([
                '2022_08_25_164456_create_duel_rounds_table',
                '2022_08_25_164458_create_duels_table',
                '2022_08_25_165513_create_duel_users_table',
                '2022_09_07_102325_create_duel_question_categories_table',
                '2022_09_07_110934_create_duel_questions_table',
                '2022_09_07_111042_create_duel_answers_table',
                '2022_09_07_111043_create_duel_user_answers_table',
            ])
            ->runsMigrations();
    }

    public function boot()
    {
        $this->loadRoutesFrom(__DIR__ . '/../routes/duel.php');
        $this->loadMigrationsFrom(__DIR__ . '/../database/migrations');

        Event::listen(DuelPossibleEndEvent::class, CheckIfDuelShouldBeClosedListener::class);
        Event::listen(DuelCloseEvent::class, CloseDuelListener::class);

        Gate::policy(Duel::class, DuelPolicy::class);

    }
}
