<?php

namespace Albedo\Duel\Commands;

use App\Models\DuelRound;
use App\Models\User;
use App\Notifications\RemindDuelNotification;
use App\Services\DuelService;
use Exception;
use Illuminate\Console\Command;
use Illuminate\Support\Carbon;

class SendEmailToRemindOfDuelsCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'make:send-email-remind-duels';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Wyślij wiadomość email przypomnienie o trwającym pojedynku.';

    /**
     * Execute the console command.
     *
     * @param DuelService $participantsWithActiveDuelService
     * @return void
     */
    public function handle(DuelService $participantsWithActiveDuelService): void
    {
        $participantsWithActiveDuelService
            ->getParticipantsWithActiveDuel()
            ->each(function (User $user) {

                try {
                    $user->notify(new RemindDuelNotification());
                } catch (Exception $ex) {
                    $this->error(sprintf('Błąd. Nie można wysłać wiadomość email do uczestnika o ID - %d', $user->id));
                    report($ex);
                }

            })
            ->whenEmpty(fn() => $this->info('Brak uczestników.'));
    }
}
