<?php

namespace Albedo\Duel\Commands;

use Albedo\Duel\Models\DuelRound;
use Carbon\CarbonPeriod;
use Illuminate\Console\Command;

class DuelRoundGeneratorCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'make:duel-round';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $start = config('duel.start');
        $end = config('duel.end');

        collect(CarbonPeriod::create($start, '5 days', $end))
            ->each(function ($date, $key) {
                DuelRound::create([
                    'name' => sprintf('Round %s', $key + 1),
                    'begin_date' => $date->copy(),
                    'end_date' => $date->copy()->addDays(6)->addHours(8),
                ]);
            });
    }
}
