<?php

namespace Albedo\Duel\Database\Factories;

use Albedo\Duel\Models\Duel;
use Albedo\Duel\Models\DuelAnswer;
use Albedo\Duel\Models\DuelQuestion;
use Albedo\Duel\Models\DuelUser;
use Albedo\Duel\Models\DuelUserAnswer;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Carbon;

class DuelUserAnswerFactory extends Factory
{
    protected $model = DuelUserAnswer::class;

    public function definition(): array
    {
        return [
            'is_correct' => true,
            'answer_expiration_date' => null,
            'answer_time' => null,
            'number' => 1,
            'number_by_category' => 1,
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),

            'duel_id' => Duel::factory(),
            'duel_user_id' => DuelUser::factory(),
            'duel_question_id' => DuelQuestion::factory(),
            'duel_answer_id' => null,
        ];
    }
}
