<?php

namespace Albedo\Duel\Http\Resources;

use Albedo\Duel\Models\DuelAnswer;
use Albedo\Duel\Models\DuelUserAnswer;
use Illuminate\Http\Resources\Json\JsonResource;

class QuestionResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return array(
            'id' => $this->id,
            'question' => $this->question,
            'category_id' => $this->duelQuestionCategory->id,
            'category' => $this->duelQuestionCategory->name,
            'total' => DuelUserAnswer::TOTAL_QUESTIONS,
            'total_questions_by_category' => $this->duelQuestionCategory->quantity_in_duel,
            'number' => $this->when($this->number, fn() => $this->number),
            'number_by_category' => $this->when($this->number_by_category, fn() => $this->number_by_category),
            'answers' => $this->duelAnswers()->get()->map(fn(DuelAnswer $duelAnswer) => new DuelAnswerResource($duelAnswer))
        );
    }
}
