<?php

namespace Albedo\Duel\Http\Resources;

use Albedo\Duel\Models\DuelUserAnswer;
use Illuminate\Http\Resources\Json\JsonResource;

class DuelUserAnswerResource extends JsonResource
{
    public function toArray($request)
    {
        $isExposed = $this->isExposed();

        return [
            'category' => $this->when(
                $this->relationLoaded('duelQuestion') &&
                $this->duelQuestion->relationLoaded('duelQuestionCategory'),
                fn() => $this->duelQuestion->duelQuestionCategory->name
            ),

            'question' => $this->whenLoaded(
                'duelQuestion',
                fn() => $this->duelQuestion->question
            ),

            'question_number' => $this->number,
            'category_question_number' => $this->number_by_category,
            'total_questions' => DuelUserAnswer::TOTAL_QUESTIONS,

            'total_category_questions' => $this->when(
                $this->relationLoaded('duelQuestion') &&
                $this->duelQuestion->relationLoaded('duelQuestionCategory'),
                fn() => $this->duelQuestion->duelQuestionCategory->quantity_in_duel
            ),

            'is_correct_answer' => $this->when(
                $isExposed,
                fn() => $this->is_correct
            ),

            'my_answer' => $this->when(
                $isExposed && $this->relationLoaded('duelAnswer'),
                fn() => $this->duelAnswer?->answer ?? ''
            ),

            'correct_answer' => $this->when(
                $isExposed && $this->relationLoaded('duelQuestion'),
                fn() => $this->duelQuestion->getCorrectAnswer()?->answer ?? 'N/A'
            ),
        ];
    }
}
