<?php

namespace Albedo\Duel\Commands;

use albedo\Duel\Facades\Duel;
use Albedo\Duel\Models\DuelRound;
use Carbon\Carbon;
use Carbon\CarbonPeriod;
use Illuminate\Console\Command;

class DuelRoundGeneratorCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'make:duel-round {--start-date= : Start date of the duel round} {--end-date= : End date of the duel round}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $start = config('duel.start_duel_round')
            ? Carbon::parse(config('duel.start_duel_round'))
            : Carbon::now()->startOfWeek()->startOfDay();

        $end = config('duel.end_duel_round')
            ? Carbon::parse(config('duel.end_duel_round'))
            : $start->copy()->addDays(6)->endOfDay();

        if (!$start instanceof Carbon) {
            $start = Carbon::create($start);
        }

        if (!$end instanceof Carbon) {
            $end = Carbon::create($end);
        }

        $duelRoundCount = DuelRound::count();

        collect(CarbonPeriod::create($start, '5 days', $end))
            ->each(function ($date) use ($duelRoundCount) {

                $start = $date->copy();
                $end = $date->copy()->addDays(6)->endOfDay();

                $duelRoundExists = DuelRound::query()
                    ->whereDate('begin_date', '>=', $start)
                    ->whereDate('end_date', '<=', $end)
                    ->exists();

                if ($duelRoundExists) {
                    $this->error('Duel round already exists');
                    return;
                }

                DuelRound::create([
                    'name' => sprintf('Round %s', $duelRoundCount + 1),
                    'begin_date' => $start,
                    'end_date' => $end,
                ]);
            });
    }
}
