<?php

namespace Albedo\Duel\Policies;

use Albedo\Duel\Models\Duel;
use Illuminate\Auth\Access\HandlesAuthorization;
use Illuminate\Contracts\Auth\Authenticatable;

class DuelPolicy
{
    use HandlesAuthorization;

    public function show(Authenticatable $user, Duel $duel): bool
    {
        return $duel->duelUsers->contains('user_id', $user->getKey());
    }

    public function question(Authenticatable $user, Duel $duel): bool
    {
        return $duel->duelUsers->contains('user_id', $user->getKey());
    }

    public function answer(Authenticatable $user, Duel $duel): bool
    {
        return $duel->duelUsers->contains('user_id', $user->getKey());
    }

    public function summary(Authenticatable $user, Duel $duel): bool
    {
        return $duel->duelUsers->contains('user_id', $user->getKey());
    }

    public function history(Authenticatable $user): bool
    {
        return true;
    }

    public function current(Authenticatable $user)
    {
        return true;
    }
}
