<?php

namespace Albedo\Duel\Http\Resources;

use Albedo\Duel\Models\DuelUserAnswer;
use Albedo\Duel\Settings\DuelSettings;
use Illuminate\Http\Resources\Json\JsonResource;

class DuelUserResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @param \Illuminate\Http\Request $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        return [
            'first_name' => $this->user?->first_name ?? 'Deleted',
            'last_name' => $this->user?->short_last_name ?? 'U.',
            'name' => $this->user?->shortName ?? 'Deleted U.',
            'time' => $this->formattedTime(),
            'points' => $this->points,
            'answers' => $this->whenLoaded(
                'duelUserAnswers', fn() => $this->duelUserAnswers
                ->filter(fn(DuelUserAnswer $duelUserAnswer) => $duelUserAnswer->isExposed())
                ->map(fn(DuelUserAnswer $duelUserAnswer) => DuelUserAnswerResource::make($duelUserAnswer))
            ),
            'answered' => $this->whenLoaded(
                'duelUserAnswers', fn() => $this->duelUserAnswers
                ->groupBy(fn(DuelUserAnswer $answer) => $answer->duelQuestion?->duelQuestionCategory?->name)
                ->map(fn($answers) => $answers->map(fn($a) => $a->answered())->values())
            )
        ];
    }
}
