<?php

namespace Albedo\Duel\Http\Controllers;

use Albedo\Duel\Http\Resources\DuelResource;
use Albedo\Duel\Models\Duel;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Response;



class DuelShowAction extends Controller
{

    /**
     * Szczegóły pojedynku
     *
     * Endpoint zwraca szczegóły pojedynku dla zalogowanego użytkownika.
     *
     * @group Pojedynki
     *
     * @urlParam duel int required ID pojedynku. Example: 123
     *
     * @response 200 scenario="Duel is ended show answers" {"status":"OK","data":{"id":1,"name":"Runda X","begin_date":"27.10","end_date":"31.10.2025","status":"finished","me":{"first_name":"Santos","last_name":"U.","name":"Deleted U.","time":"00:00","points":null,"answers":[{"category":"Miss Elva Hegmann","question":"xxxxxxxxxxxxxxxx","question_number":1,"category_question_number":0,"total_questions":9,"total_category_questions":3,"is_correct_answer":true,"my_answer":"","correct_answer":"xxxxxxx"},{"category":"Miss Elva Hegmann","question":"xxxxxxxxxxxxxxxx","question_number":1,"category_question_number":0,"total_questions":9,"total_category_questions":3,"is_correct_answer":true,"my_answer":"","correct_answer":"xxxxxxxxxx"},{"category":"Miss Elva Hegmann","question":"xxxx","question_number":1,"category_question_number":0,"total_questions":9,"total_category_questions":3,"is_correct_answer":true,"my_answer":"","correct_answer":"xxxxxxxxxx"},{"category":"Ms. Whitney Schmidt","question":"xxxxxxxxxxxxxxxxxx","question_number":1,"category_question_number":1,"total_questions":9,"total_category_questions":3,"is_correct_answer":true,"my_answer":"","correct_answer":"xxxxxxx"},{"category":"Ms. Whitney Schmidt","question":"xxxxxxxxxxxxxxxx","question_number":1,"category_question_number":1,"total_questions":9,"total_category_questions":3,"is_correct_answer":true,"my_answer":"","correct_answer":"xxxxxxxxx"},{"category":"Ms. Whitney Schmidt","question":"xxxxxxxxx","question_number":1,"category_question_number":1,"total_questions":9,"total_category_questions":3,"is_correct_answer":true,"my_answer":"","correct_answer":"xxxxx"},{"category":"Miss Brigitte Emard","question":"xxxxxxx","question_number":1,"category_question_number":2,"total_questions":9,"total_category_questions":3,"is_correct_answer":true,"my_answer":"","correct_answer":"xxxxxxxxx"},{"category":"Miss Brigitte Emard","question":"xxxxxxxxxx","question_number":1,"category_question_number":2,"total_questions":9,"total_category_questions":3,"is_correct_answer":true,"my_answer":"","correct_answer":"xxxxxxxx"},{"category":"Miss Brigitte Emard","question":"xxxxxxxxxxxxxxxxxxxx","question_number":1,"category_question_number":2,"total_questions":9,"total_category_questions":3,"is_correct_answer":true,"my_answer":"","correct_answer":"xxxxxxxxx"}]},"opponent":{"first_name":"Lyda","last_name":"U.","name":"Deleted U.","time":"00:00","points":null,"answers":[{"category":"Miss Elva Hegmann","question":"xxxxxxxxxxxxxxxx","question_number":1,"category_question_number":0,"total_questions":9,"total_category_questions":3,"is_correct_answer":true,"my_answer":"","correct_answer":"xxxxxxx"},{"category":"Miss Elva Hegmann","question":"xxxxxxxxxxxxxxxx","question_number":1,"category_question_number":0,"total_questions":9,"total_category_questions":3,"is_correct_answer":true,"my_answer":"","correct_answer":"xxxxxxxxxx"},{"category":"Miss Elva Hegmann","question":"xxxx","question_number":1,"category_question_number":0,"total_questions":9,"total_category_questions":3,"is_correct_answer":true,"my_answer":"","correct_answer":"xxxxxxxxxx"},{"category":"Ms. Whitney Schmidt","question":"xxxxxxxxxxxxxxxxxx","question_number":1,"category_question_number":1,"total_questions":9,"total_category_questions":3,"is_correct_answer":true,"my_answer":"","correct_answer":"xxxxxxx"},{"category":"Ms. Whitney Schmidt","question":"xxxxxxxxxxxxxxxx","question_number":1,"category_question_number":1,"total_questions":9,"total_category_questions":3,"is_correct_answer":true,"my_answer":"","correct_answer":"xxxxxxxxx"},{"category":"Ms. Whitney Schmidt","question":"xxxxxxxxx","question_number":1,"category_question_number":1,"total_questions":9,"total_category_questions":3,"is_correct_answer":true,"my_answer":"","correct_answer":"xxxxx"},{"category":"Miss Brigitte Emard","question":"xxxxxxx","question_number":1,"category_question_number":2,"total_questions":9,"total_category_questions":3,"is_correct_answer":true,"my_answer":"","correct_answer":"xxxxxxxxx"},{"category":"Miss Brigitte Emard","question":"xxxxxxxxxx","question_number":1,"category_question_number":2,"total_questions":9,"total_category_questions":3,"is_correct_answer":true,"my_answer":"","correct_answer":"xxxxxxxx"},{"category":"Miss Brigitte Emard","question":"xxxxxxxxxxxxxxxxxxxx","question_number":1,"category_question_number":2,"total_questions":9,"total_category_questions":3,"is_correct_answer":true,"my_answer":"","correct_answer":"xxxxxxxxx"}]}},"meta":[],"message":"Duel information retrieved successfully","errors":null}
     * @response 200 scenario="Duel is not ended hide answers" {"status":"OK","data":{"id":1,"name":"Runda X","begin_date":"27.10","end_date":"31.10.2025","status":"in-progress","me":{"first_name":"Dahlia","last_name":"U.","name":"Deleted U.","time":"00:00","points":null,"answers":[]},"opponent":{"first_name":"Kiarra","last_name":"U.","name":"Deleted U.","time":"00:00","points":null,"answers":[]}},"meta":[],"message":"Duel information retrieved successfully","errors":null}
     * @response 403 { "message": "Forbidden" }
     */
    public function __invoke(Duel $duel)
    {
        $duelResource = DuelResource::make($duel->load([
            'duelUsers.duelUserAnswers.duelAnswer',
            'duelUsers.duelUserAnswers.duelQuestion.duelQuestionCategory',
            'duelUsers.duelUserAnswers.duelQuestion.duelAnswers',
            'duelRound'
        ]))
            ->additional([
                'me' => $duel->duelUsers->where('user_id', auth()->id())->first(),
                'opponent' => $duel->duelUsers->where('user_id', '!=', auth()->id())->first()
            ]);

        return Response::success(
            data: $duelResource,
            message: "Duel information retrieved successfully");
    }
}
