<?php

namespace Albedo\Duel\Http\Controllers;

use Albedo\Duel\Http\Resources\DuelResource;
use Albedo\Duel\Models\Duel;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Response;


class DuelHistoryAction extends Controller
{
    public function __construct(
        protected Authenticatable $user,
    )
    {
    }

    /**
     * Historię pojedynków
     *
     * Endpoint zwraca listę wszystkich pojedynków, w których bierze udział zalogowany użytkownik.
     *
     * @group Pojedynki
     *
     * @response 200 scenario="Lista pojedynków" {
     *   "status": "OK",
     *   "data": [
     *     {
     *       "id": 1,
     *       "name": "Runda X",
     *       "begin_date": "27.10",
     *       "end_date": "31.10.2025",
     *       "status": "finished",
     *       "me": {
     *         "first_name": "Santos",
     *         "last_name": "U.",
     *         "name": "Deleted U.",
     *         "time": "00:00",
     *         "points": 0,
     *         "answers": []
     *       },
     *       "opponent": {
     *         "first_name": "Lyda",
     *         "last_name": "U.",
     *         "name": "Deleted U.",
     *         "time": "00:00",
     *         "points": 0,
     *         "answers": []
     *       }
     *     }
     *   ],
     *   "message": "Success"
     * }
     * @response 200 scenario="Brak pojedynków" {
     *   "status": "OK",
     *   "data": [],
     *   "message": "Success"
     * }
     * @response 403 { "message": "Forbidden" }
     */
    public function __invoke()
    {
        $duels = Duel::whereHas('duelUsers', fn($q) => $q->whereUserId($this->user->getKey()))
            ->orderByDesc('created_at')
            ->get();

        return Response::success(data: DuelResource::collection($duels), message: "Success");
    }
}
