<?php

namespace Albedo\Duel\Database\Factories;

use Albedo\Duel\Models\DuelRound;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\DuelRound>
 */
class DuelRoundFactory extends Factory
{
    protected $model = DuelRound::class;

    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'name' => 'Runda X',
            'begin_date' => now()->copy()->startOfWeek()->startOfDay(),
            'end_date' => now()->copy()->startOfWeek()->addDays(4)->endOfDay(),
        ];
    }
}
