<?php

namespace Albedo\Duel\Commands;

use Albedo\Duel\Models\Duel;
use Albedo\Duel\Services\DuelService;
use Illuminate\Console\Command;
use Throwable;

class CloseUserDuelsCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'duel:close';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     *
     * @return int
     */
    public function handle()
    {
        $duelService = app(DuelService::class);

        $this->line('Start');

        DB::transaction(function () use ($duelService) {

            $duelService->getNonCompletedDuels()
                ->each(function (Duel $duel) use ($duelService) {

                    $this->output->write('ID - ' . $duel->id);

                    try {
                        $duelService->resolveDuel($duel);
                    } catch (Throwable $ex) {
                        $this->error($ex->getMessage());
                        report($ex);
                    }

                    $this->output->writeln(' - Zamknięty');
                });
        });


        $this->line('Zakończono');

        return Command::SUCCESS;
    }
}
