<?php

namespace Albedo\Duel\Database\Factories;

use Albedo\Duel\Enums\DuelProgressStatusEnum;
use Albedo\Duel\Models\Duel;
use Albedo\Duel\Models\DuelRound;
use Illuminate\Database\Eloquent\Factories\Factory;
use Illuminate\Support\Carbon;

class DuelFactory extends Factory
{
    protected $model = Duel::class;

    public function definition(): array
    {
        return [
            'duel_round_id' => DuelRound::factory(),
            'progress_status' => DuelProgressStatusEnum::NOT_PARTICIPATED,
            'created_at' => Carbon::now(),
            'updated_at' => Carbon::now(),
        ];
    }
}
