<?php

namespace Albedo\Duel\Models;

use Albedo\Gamification\Enums\ActivityGroupEnum;
use Albedo\Gamification\Models\Traits\PointableTrait;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class DuelUserAnswer extends Model
{
    use HasFactory, PointableTrait;

    public const TOTAL_QUESTIONS = 9;
    public const TOTAL_QUESTIONS_BY_CATEGORY = 3;

    protected $guarded = [];

    protected $casts = [
        'is_correct' => 'bool',
        'answer_expiration_date' => 'datetime',
    ];

    public function duel(): BelongsTo
    {
        return $this->belongsTo(Duel::class);
    }

    public function duelUser(): BelongsTo
    {
        return $this->belongsTo(DuelUser::class);
    }

    public function duelQuestion(): BelongsTo
    {
        return $this->belongsTo(DuelQuestion::class);
    }

    public function duelAnswer(): BelongsTo
    {
        return $this->belongsTo(DuelAnswer::class);
    }

    public function getActivityGroup(): string
    {
        return ActivityGroupEnum::DUEL->value;
    }

    public function isExposed(): bool
    {
        return $this->duel->isFinished()
            || (auth()->id() === $this->duelUser->user_id && $this->duelUser->isFinished());
    }

    public function answered()
    {
        return $this->getAttribute('duel_answer_id') !== null
            || $this->getAttribute('answer_expiration_date')?->isPast();
    }

    protected static function newFactory()
    {
        return \Albedo\Duel\Database\Factories\DuelUserAnswerFactory::new();
    }
}
