<?php

namespace Albedo\Duel\Models;

use Albedo\Duel\Database\Factories\DuelFactory;
use Albedo\Ranking\Models\RankingPeriod;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class DuelRound extends Model
{
    use HasFactory;

    protected $guarded = [];

    protected $casts = [
        'begin_date' => 'datetime',
        'end_date' => 'datetime',
    ];

    public function duels(): HasMany
    {
        return $this->hasMany(Duel::class);
    }

    public function duelQuestions(): HasMany
    {
        return $this->hasMany(DuelQuestion::class);
    }

    public function nameWithDate(): Attribute
    {
        return Attribute::make(
            get: fn(): string => sprintf(
                '%s - %s/%sr.',
                $this->getStartDate(),
                $this->getStartDate()->format('d.m'),
                $this->getEndDate()->format('d.m.Y')
            )
        );
    }

    public static function getCurrent(): ?DuelRound
    {
        return self::query()
            ->where('begin_date', '<=', now())
            ->where('end_date', '>=', now())
            ->first();
    }

    protected static function newFactory()
    {
        return \Albedo\Duel\Database\Factories\DuelRoundFactory::new();
    }
}
